package org.cadenhead.minecraft;

import java.util.*;
import java.util.logging.*;
import org.bukkit.*;
import org.bukkit.command.*;
import org.bukkit.entity.*;
import org.bukkit.plugin.java.*;

public class LightningStorm extends JavaPlugin {
    public static final Logger log = Logger.getLogger("Minecraft");
   
    public boolean onCommand(CommandSender sender, Command command, 
        String label, String[] arguments) {
       
        Player me = (Player) sender;
        World world = me.getWorld();
        // Pobierz dane wszystkich ywych mobw w grze
        List<LivingEntity> mobs = world.getLivingEntities();
                        
        // Przetwrz polecenie lightningstorm
        if (label.equalsIgnoreCase("lightningstorm")) { 
            if (sender instanceof Player) { 
                int myId = me.getEntityId();
                // Wykonaj ptle dla kadego moba
                for (LivingEntity mob : mobs) {
                    log.info("[LightningStorm]" + mob.getType());
                    // Czy ten mob jest graczem?
                    if (mob.getEntityId() == myId) {
                        // Tak, wic go nie trafiaj
                        continue;
                    }
                    // Pobierz lokalizacj moba
                    Location spot = mob.getLocation();
                    // Uderzenie pioruna!
                    world.strikeLightning(spot);
                    // Ustaw zdrowie moba na 0 (martwy)
                    mob.setHealth(0);
                }
            }
            return true;
        }
        
        // Przetwrz polecenie mobcount
        if (label.equalsIgnoreCase("mobcount")) {
            if (sender instanceof Player) {
                me.sendMessage("Istnieje " + mobs.size() + " ywych mobw.");
                return true;
            }
        }
        return false;
    }
}
